// MSR_SOIMPL.H : Declaration of the TMSR_SOImpl

#ifndef __MSR_SOIMPL_H_
#define __MSR_SOIMPL_H_

#include "OPOS_TLB.h"
// process queue
#include "queue.h"
// include thread use
#include <Classes.hpp>
// include Registry use
#include <Registry.hpp>
// include delay use
#include <mmsystem.h>

// include opos header file
#include "opos.h"
#include "opos.hi"
#include "oposmsr.h"
#include "oposmsr.hi"
// define normal string
#define SERVICEOBJECTDESCRIPTION "OPOS MSR Service Object"
#define SERVICEOBJECTVERSION 1006000L //1001001L
#define DEVICEDESCRIPTION "OPOS MSR"
#define DEVICENAME "OPOS.MSRSO"


#define OPOSDIRECTIOEVENT		  2
#define OPOSSTATUSUPDATEEVENT	  5
#define OPOSDATAEVENT     3
#define OPOSERROREVENT  4

#define OPOSMSRSOKey "SOFTWARE\\OLEforRetail\\ServiceOPOS\\MSR\\"

typedef struct _OPOS_MESSAGE_STRUCT
{
    char sDevice[20];
    char sDName[25];
    long lSoVer;
    long sCommand;
    char sMessage[256];
    int lMsglevel;
}
OPOSStruct;

OPOSStruct ms;
const LONG OPOS_C_OPEN          = 500;
const LONG OPOS_C_CLAIM_ENABLE  = 501;
const LONG OPOS_C_CLAIM_DISABLE = 502;
const LONG OPOS_C_DEVICE_ENABLE = 503;
const LONG OPOS_C_DEVICE_DISABLE= 504;
const LONG OPOS_C_CLOSE         = 505;

struct SMData
{
    long RefCount;
    bool ClaimedFlag;
    HANDLE ClaimedMutex;
    HANDLE ReleasedEvent;
};

struct MSRData
{
    char MSRTrack1Data[256];
    char MSRTrack1Len;
    unsigned char MSRTrack1LRC;
    char MSRTrack2Data[256];
    char MSRTrack2Len;
    unsigned char MSRTrack2LRC;
    char MSRTrack3Data[256];
    char MSRTrack3Len;
    unsigned char MSRTrack3LRC;
    char MSRTrack4Data[256];
    char MSRTrack4Len;
    unsigned char MSRTrack4LRC;
};

struct MSRRegisterData
{
    unsigned int CapsLockKey;
    unsigned int LRCOnOff;
    unsigned int DebugMode;
    char MSRCardFormat[10];
    char MSRInterface[10];
    char Track1Pre;
    char Track1Post;
    char Track2Pre;
    char Track2Post;
    char Track3Pre;
    char Track3Post;
    char Track4Pre;
    char Track4Post;
    unsigned int TrackCount;
    char MSRPrefix[10];
    char MSRTrack1Prefix[10];
    char MSRTrack2Prefix[10];
    char MSRTrack3Prefix[10];
    char MSRTrack1Sufix[10];
    char MSRTrack2Sufix[10];
    char MSRTrack3Sufix[10];
    unsigned int ScanCodeOnOff;
    char MSRTrack1PreHex[10];
    char MSRTrack2PreHex[10];
    char MSRTrack3PreHex[10];
    char MSRTrack1SuHex[10];
    char MSRTrack2SuHex[10];
    char MSRTrack3SuHex[10];
    char MSRTerminator[5];
    unsigned int MSRDelayTime;
    char MSRComPort[10];
    char MSRBaud[10];
    char MSRParity[10];
    char MSRDataLength[10];
    char MSRStopBit[10];

};
// OPOS event class define
class TOPOSEvent: public TObject
{
public:
    int EventType;
};

class TDataEvent : public TOPOSEvent
{
public:
    long Status;
};

class TDirectIOEvent : public TOPOSEvent
{
public:
    long EventNumber;
    long* pData;
    BSTR* pString;
};

class TErrorEvent : public TOPOSEvent
{
public:
    long ResultCode;
    long ResultCodeExtended;
    long ErrorLocus;
    long* pErrorResponse;
};
class TMyTimer: public TThread
{
private:
protected:
    void __fastcall Execute();
public:
    __fastcall TMyTimer(bool CreateSuspended);
};

class TOverTimer: public TThread
{
private:
protected:
    void __fastcall Execute();
public:
    __fastcall TOverTimer(bool CreateSuspended);
};

class TStatusUpdateEvent : public TOPOSEvent
{
public:
    long Data;
};

// process event
class TEventThread:public TThread
{
private:
protected:
    void __fastcall Execute();
public:
    __fastcall TEventThread(bool CreateSuspended);
};

class TDataEndThread:public TThread
{
private:
protected:
    void __fastcall Execute();
public:
    __fastcall TDataEndThread(bool CreateSuspended);
};


/////////////////////////////////////////////////////////////////////////////
// TMSR_SOImpl     Implements IMSR_SO, default interface of MSR_SO
// ThreadingModel : Apartment
// Dual Interface : FALSE
// Event Support  : FALSE
// Default ProgID : MSRSO.MSR_SO
// Description    :
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TMSR_SOImpl :
            public CComObjectRootEx<CComSingleThreadModel>,
            public CComCoClass<TMSR_SOImpl, &CLSID_MSR_SO>,
            public IDispatchImpl<IMSR_SO,&IID_IMSR_SO,&LIBID_OPOS>
{
    friend class TEventThread;
    friend class TMyTimer;
    friend class TOverTimer;
    friend class TDataEndThread;
public:
    TMSR_SOImpl()
    {
        m_AutoDisable=false;
        m_BinaryConversion=OPOS_BC_NONE;
        m_CapPowerReporting=OPOS_PR_NONE;
        m_Claimed=false;
        m_DataCount=0L;
        m_DataEventEnabled=false;
        m_DeviceEnabled=false;
        m_FreezeEvents=false;
        m_ResultCode=OPOS_SUCCESS;
        m_ResultCodeExtended=0;
        m_PowerNotify=OPOS_PN_DISABLED;
        m_PowerState=OPOS_PS_UNKNOWN;
        m_State=OPOS_S_CLOSED;
        m_CapISO=false;
        m_CapJISOne=false;
        m_CapJISTwo=false;
        m_CapTransmitSentinels=false;
        m_TracksToRead=MSR_TR_1_2_3;
        m_DecodeData=true;
        m_ParseDecodeData=true;
        m_ErrorReportingType=MSR_ERT_CARD;
        m_Track1Data.Empty();
        m_Track2Data.Empty();
        m_Track3Data.Empty();
        m_Track4Data.Empty();
        m_AccountNumber.Empty();
        m_ExpirationDate.Empty();
        m_Title.Empty();
        m_FirstName.Empty();
        m_MiddleInitial.Empty();
        m_Surname.Empty();
        m_Suffix.Empty();
        m_ServiceCode.Empty();
        m_Track1DiscretionaryData.Empty();
        m_Track2DiscretionaryData.Empty();
        m_TransmitSentinels=false;
        m_LRCCheck=false;
    }

    // Data used when registering Object
    //
    DECLARE_THREADING_MODEL(otApartment);
    DECLARE_PROGID("OPOS.MSRSO");
    DECLARE_DESCRIPTION("OPOS Library For MSR");

    // Function invoked to (un)register object
    //
    static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
    {
        TTypedComServerRegistrarT<TMSR_SOImpl>
        regObj(GetObjectCLSID(), GetProgID(), GetDescription());
        return regObj.UpdateRegistry(bRegister);
    }


    BEGIN_COM_MAP(TMSR_SOImpl)
    COM_INTERFACE_ENTRY(IMSR_SO)
    COM_INTERFACE_ENTRY(IDispatch)
    END_COM_MAP()

private:
    bool m_AutoDisable;
    long m_BinaryConversion;
    long m_CapPowerReporting;
    WideString m_CheckHealthText;
    bool m_Claimed;
    long m_DataCount;
    bool m_DataEventEnabled;
    bool m_DeviceEnabled;
    bool m_FreezeEvents;
    long m_OpenResult;
    long m_OutputID; //Non-support
    long m_PowerNotify;
    long m_PowerState;
    long m_ResultCode;
    long m_ResultCodeExtended;
    long m_State;
    WideString m_ControlObjectDescription;
    long m_ControlObjectVersion;
    WideString m_ServiceObjectDescription;
    long m_ServiceObjectVersion;
    WideString m_DeviceDescription;
    WideString m_DeviceName;
    bool m_CapISO;
    bool m_CapJISOne;
    bool m_CapJISTwo;
    bool m_CapTransmitSentinels;
    long m_TracksToRead;
    bool m_DecodeData;
    bool m_ParseDecodeData;
    long m_ErrorReportingType;
    WideString m_Track1Data;
    WideString m_Track2Data;
    WideString m_Track3Data;
    WideString m_Track4Data;
    int m_Track1Length;
    int m_Track2Length;
    int m_Track3Length;
    int m_Track4Length;
    WideString m_AccountNumber;
    WideString m_ExpirationDate;
    WideString m_Title;
    WideString m_FirstName;
    WideString m_MiddleInitial;
    WideString m_Surname;
    WideString m_Suffix;
    WideString m_ServiceCode;
    WideString m_Track1DiscretionaryData;
    WideString m_Track2DiscretionaryData;
    bool m_TransmitSentinels;
    WideString t_Track1Data;
    WideString t_Track2Data;
    WideString t_Track3Data;
    WideString t_Track4Data;
    int t_Track1Length;
    int t_Track2Length;
    int t_Track3Length;
    int t_Track4Length;
    WideString t_AccountNumber;
    WideString t_ExpirationDate;
    WideString t_Title;
    WideString t_FirstName;
    WideString t_MiddleInitial;
    WideString t_Surname;
    WideString t_Suffix;
    WideString t_ServiceCode;
    WideString t_Track1DiscretionaryData;
    WideString t_Track2DiscretionaryData;
    wchar_t t_Track1DataMatrix[128];
    wchar_t t_Track2DataMatrix[128];
    wchar_t t_Track3DataMatrix[128];
    wchar_t t_Track4DataMatrix[128];
    wchar_t t_AccountNumberMatrix[128];
    wchar_t t_ExpirationDateMatrix[4]; // length shold be 4
    wchar_t t_TitleMatrix[128];
    wchar_t t_FirstNameMatrix[64];
    wchar_t t_MiddleInitialMatrix[64];
    wchar_t t_SurnameMatrix[64];
    wchar_t t_SuffixMatrix[64];
    wchar_t t_ServiceCodeMatrix[10];  //length should be 3
    wchar_t t_Track1DiscretionaryDataMatrix[128];
    wchar_t t_Track2DiscretionaryDataMatrix[128];
    wchar_t m_Track1DataMatrix[128];
    wchar_t m_Track2DataMatrix[128];
    wchar_t m_Track3DataMatrix[128];
    wchar_t m_Track4DataMatrix[128];
    wchar_t m_AccountNumberMatrix[128];
    wchar_t m_ExpirationDateMatrix[4]; // length shold be 4
    wchar_t m_TitleMatrix[128];
    wchar_t m_FirstNameMatrix[64];
    wchar_t m_MiddleInitialMatrix[64];
    wchar_t m_SurnameMatrix[64];
    wchar_t m_SuffixMatrix[64];
    wchar_t m_ServiceCodeMatrix[10];  //length should be 3
    wchar_t m_Track1DiscretionaryDataMatrix[128];
    wchar_t m_Track2DiscretionaryDataMatrix[128];

    MSRRegisterData *RegData;

    MSRData m_MSRData;
    HANDLE IORWMutex;   // share memory read priority
    HANDLE m_EventQueueAvailable;
    HANDLE EventThreadActive;
    HANDLE EventThreadTerminated;
    HANDLE FreezeEventsUnfrozen;
    HANDLE DllGetDataEvent;
    HANDLE COFreezeEventsUnfrozen;
    HANDLE DataEventEnable;
    HANDLE DllDataAvailable; //mutex dll share memory read priority
    HANDLE GetDataTerminatedEvent;
    HANDLE EventTimeOut;
    HANDLE OperationMutex;
    HANDLE mIORWMutex;
    HANDLE EnableDllDataEvent;  // for process dll data event thread
    HANDLE DisableDllDataEvent; // for process dll share memory data thread
    HANDLE EnableDllDataEventTerminated;
    HANDLE TimerActive;

    queue<TOPOSEvent*> m_EventQueue;
    DISPID  CODispatchID[4];
    TEventThread *EventThread;
    TMyTimer *mTimer;
    TOverTimer *mOTimer;
    TDataEndThread *mDataEndThread;
    bool m_LRCCheck;
    int m_TrackCount;
    char mGetDataCheck;
    long mlCountData;
    void CleanData();

// IMSR_SO
public:

    STDMETHOD(CheckHealth(long Level, long* pRC));
    STDMETHOD(Claim(long Timeout, long* pRC));
    STDMETHOD(ClaimDevice(long Timeout, long* pRC));
    STDMETHOD(ClearInput(long* pRC));
    STDMETHOD(ClearOutput(long* pRC));
    STDMETHOD(Close(long* pRC));
    STDMETHOD(COFreezeEvents(TOLEBOOL Freeze, long* pRC));
    STDMETHOD(DirectIO(long Command, long* pData, BSTR* pString, long* pRC));
    STDMETHOD(GetOpenResult(long* pRC));
    STDMETHOD(GetPropertyNumber(long PropIndex, long* pNumber));
    STDMETHOD(GetPropertyString(long PropIndex, BSTR* pString));
    STDMETHOD(OpenService(BSTR DeviceClass, BSTR DeviceName,
                          LPDISPATCH pDispatch, long* pRC));
    STDMETHOD(ReleaseDevice(long* pRC));
    STDMETHOD(SetPropertyNumber(long PropIndex, long Number));
    STDMETHOD(SetPropertyString(long PropIndex, BSTR String));
    STDMETHOD(CloseService(long* pRC));

};
void __fastcall Delay(unsigned int mSec);
void __fastcall ClearData();
AnsiString __fastcall TrimStr( AnsiString Tm , AnsiString LR );
#endif //__MSR_SOIMPL_H_
